using ComponentPro;

namespace AdvancedDemo.Samples.Function_and_Property
{
    public static class MyTestClass
    {
        public static string TestString
        {
            get { return "Static String"; }
        }
        public static string GetStaticString(string s)
        {
            return string.Format("GetStaticString returns {0}", s);
        }
    }
    public static class ClassRestricted
    {
        public static string TestString
        {
            get { return "Test String in a restricted class"; }
        }
    }
    public static class MethodAndProperty
    {
        public static string TestStringRestricted
        {
            get { return "Restricted String"; }
        }
        public static string GetStaticStringRestricted(string s)
        {
            return string.Format("GetStaticStringRestricted returns {0}", s);
        }
        public static string StaticStringAllowed
        {
            get
            {
                return "StaticStringAllowed";
            }
        }
    }

    class Calling_Restriction : TemplateExampleBase
    {
        /// <summary>
        /// Generates output from a template file.
        /// </summary>
        /// <param name="templateSourceDirectory">The path to the directory that contains the template file.</param>
        /// <param name="templateFile">The template file path.</param>
        /// <param name="templateSource">The template source loaded from the template file.</param>
        /// <returns>The generated output.</returns>
        public override string Generate(string templateSourceDirectory, string templateFile, string templateSource)
        {
            // Create a new instance of the TemplateEngine class.
            TemplateEngine dt = new TemplateEngine();

            // Load template content from a file.
            dt.LoadFromString(templateSource);
            dt.SetValue("TemplateSourceDirectory", templateSourceDirectory);

            Book mybook = new Book();
            dt.SetValue("bk", mybook);

            dt.UsingNamespace("AdvancedDemo.Samples.Function_and_Property,AdvancedDemo");

            dt.RestrictedMethodList.Add("*.ClassRestricted.*");
            dt.RestrictedPropertyList.Add("*.ClassRestricted.*");
            dt.RestrictedMethodList.Add("*.MethodAndProperty.GetStaticString*");
            dt.AllowedMethodList.Add("*.MethodAndProperty.GetStaticStringAllowed");
            dt.RestrictedPropertyList.Add("*.TestStringRestricted");

            // Generate output.
            string output = dt.Run();

            return output;
        }
    }
}
